/**
 * \file        Cresnetconsole.hpp
 * \brief       class definition for redirection of the console port to cresnet
 * \author      Larry Salant
 * \date        2/6/2009
 *
 */
#ifndef __CRESNETCONSOLE_HPP__
#define __CRESNETCONSOLE_HPP__

#include "console.h"
class CCresnetConsole
{
  public:
    CCresnetConsole(void);
    void CresnetConsoleRedirectConnect(UINT8 * packet);
    void CresnetConsoleRedirectDisc(UINT8 * packet);
    void CresnetConsoleRedirectData(UINT8 * packet, UINT32 packlen);
    BOOL CresnetConsoleRedirectIsActive(void);
    BOOL CresnetConsoleProcessRcon(UINT8 * pPacket, UINT16 sTimeout);
    UINT32 CresnetConsoleGetSource(void);

  private:  
    BOOL  m_redirectActive;
	CMDINPUT m_cmdInput;
};

extern CCresnetConsole *CresnetConsole;

#endif  //__CRESNETCONSOLE_HPP__










